/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.items;

import java.util.Optional;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControllerTileEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class VehicleControlScreenModule
implements IScreenModule<EmptyData> {
    private ResourceKey<Level> dim = Level.f_46428_;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private String line = "";
    private String mover = "";
    private String vehicle = "";

    public EmptyData getData(IScreenDataHelper helper, Level worldObj, long millis) {
        return null;
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            this.line = tagCompound.m_128461_("text");
            this.mover = tagCompound.m_128461_("mover");
            this.vehicle = tagCompound.m_128461_("vehicle");
        }
    }

    private void setupCoordinateFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.m_128441_("monitorx")) {
            this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
            this.coordinate = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
        }
    }

    public int getRfPerTick() {
        return (Integer)MoverConfiguration.VEHICLE_CONTROL_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
        int xoffset = !this.line.isEmpty() ? 40 : 5;
        if (x >= xoffset) {
            if (!this.mover.isEmpty()) {
                VehicleControlScreenModule.getMoverController(world, this.dim, this.coordinate).ifPresent(controller -> controller.setupMovement(this.mover, this.vehicle));
            } else if (player != null) {
                player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Module is not linked to mover controller!")), false);
            }
        }
    }

    public static Optional<MoverControllerTileEntity> getMoverController(Level worldObj, ResourceKey<Level> dim, BlockPos coordinate) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, dim);
        if (world == null) {
            return Optional.empty();
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)coordinate)) {
            return Optional.empty();
        }
        BlockEntity te = world.m_7702_(coordinate);
        if (te == null) {
            return Optional.empty();
        }
        if (!(te instanceof MoverControllerTileEntity)) {
            return Optional.empty();
        }
        return Optional.of((MoverControllerTileEntity)te);
    }

    public static class EmptyData
    implements IModuleData {
        public static final String ID = "rftoolsbuilder:vehicle_control";

        public EmptyData(FriendlyByteBuf buf) {
        }

        public String getId() {
            return ID;
        }

        public void writeToBuf(FriendlyByteBuf buf) {
        }
    }
}

